//Image analysis on 256*256 image size
//Scilab 5.4.1
//Windows 10 
//Requires SIVP, IPD toolboxes

clear;
clc;

I=imread('cameraman.jpg');

//Break the cameraman image of dimension 256x256 into four equal
//square shapes C11, C12, C21 & C22 and display all into a single 
//figure of 2x2 dimensions.
C11=I(1:128, 1:128);
C12=I(1:128, 129:256);
C21=I(129:256, 1:128);
C22=I(129:256, 129:256);
imwrite(C11,'C11.jpeg');//Top Left
imwrite(C12,'C12.jpeg');//Top Right
imwrite(C21,'C21.jpeg');//Bottom Left
imwrite(C22,'C22.jpeg');//Bottom Right
J=[C11 C12; C21 C22];//Reconstruct original image from the squares
imwrite(J,'Single.jpeg');//Reconstructed image from squares

//Interchange the C11 & C22 and C12 & C21 and show the image
K=[C22 C21; C12 C11];
imwrite(K,'Interchange.jpeg');//Interchanged image
